package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TipoDocumentoDao;
import com.ejie.ab04b.model.TipoDocumento;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0491s00ServiceImpl generated by UDA, 15-Feb-2017 11:33:53.
 * 
 * @author UDA
 */

@Service(value = "ab0491s00Service")
public class TipoDocumentoServiceImpl implements TipoDocumentoService {

	@Autowired()
	private TipoDocumentoDao ab0491s00Dao;

	/**
	 * Inserts a single row in the Ab0491s00 table.
	 * 
	 *  ab0491s00
	 *            Ab0491s00
	 *  Ab0491s00
	 *
	 * @param ab0491s00 the ab 0491 s 00
	 * @return the tipo documento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoDocumento add(TipoDocumento ab0491s00) {
		return this.ab0491s00Dao.add(ab0491s00);
	}

	/**
	 * Updates a single row in the Ab0491s00 table.
	 * 
	 *  ab0491s00
	 *            Ab0491s00
	 *  Ab0491s00
	 *
	 * @param ab0491s00 the ab 0491 s 00
	 * @return the tipo documento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoDocumento update(TipoDocumento ab0491s00) {
		return this.ab0491s00Dao.update(ab0491s00);
	}

	/**
	 * Finds a single row in the Ab0491s00 table.
	 * 
	 *  ab0491s00
	 *            Ab0491s00
	 *  Ab0491s00
	 *
	 * @param ab0491s00 the ab 0491 s 00
	 * @return the tipo documento
	 */
	public TipoDocumento find(TipoDocumento ab0491s00) {
		return (TipoDocumento) this.ab0491s00Dao.find(ab0491s00);
	}

	/**
	 * Finds a single row in the Ab0491s00 table.
	 * 
	 *  ab0491s00
	 *            Ab0491s00
	 *  Ab0491s00
	 *
	 * @param ab0491s00 the ab 0491 s 00
	 * @return the tipo documento
	 */
	public TipoDocumento findByTipoAsuntoDocumental(TipoDocumento ab0491s00) {
		return (TipoDocumento) this.ab0491s00Dao
				.findByTipoAsuntoDocumental(ab0491s00);
	}

	/**
	 * Deletes a single row in the Ab0491s00 table.
	 * 
	 *  ab0491s00
	 *            Ab0491s00
	 *
	 * @param ab0491s00 the ab 0491 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoDocumento ab0491s00) {
		this.ab0491s00Dao.remove(ab0491s00);
	}

	/**
	 * Finds a list of rows in the Ab0491s00 table.
	 * 
	 *  ab0491s00
	 *            Ab0491s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0491s00>
	 *
	 * @param ab0491s00 the ab 0491 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TipoDocumento> findAll(TipoDocumento ab0491s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<TipoDocumento>) this.ab0491s00Dao.findAll(ab0491s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0491s00 table using like.
	 * 
	 *  ab0491s00
	 *            Ab0491s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0491s00>
	 *
	 * @param ab0491s00 the ab 0491 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TipoDocumento> findAllLike(TipoDocumento ab0491s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<TipoDocumento>) this.ab0491s00Dao.findAllLike(ab0491s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0491s00 table.
	 * 
	 *  filterAb0491s00
	 *            Ab0491s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0491s00>
	 *
	 * @param filterAb0491s00 the filter ab 0491 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<TipoDocumento> filter(
			TipoDocumento filterAb0491s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<TipoDocumento> listaAb0491s00 = this.ab0491s00Dao
				.findAllLike(filterAb0491s00, jqGridRequestDto, false);
		Long recordNum = this.ab0491s00Dao.findAllLikeCount(
				filterAb0491s00 != null ? filterAb0491s00 : new TipoDocumento(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<TipoDocumento>> reorderSelection = this.ab0491s00Dao
					.reorderSelection(filterAb0491s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<TipoDocumento>(jqGridRequestDto,
					recordNum, listaAb0491s00, reorderSelection);
		}
		return new JQGridResponseDto<TipoDocumento>(jqGridRequestDto, recordNum,
				listaAb0491s00);
	}

	/**
	 * Searches rows in the Ab0491s00 table.
	 * 
	 *  filterAb0491s00
	 *            Ab0491s00
	 *  searchAb0491s00
	 *            Ab0491s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0491s00>>
	 *
	 * @param filterAb0491s00 the filter ab 0491 s 00
	 * @param searchAb0491s00 the search ab 0491 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<TipoDocumento>> search(
			TipoDocumento filterAb0491s00, TipoDocumento searchAb0491s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0491s00Dao.search(filterAb0491s00, searchAb0491s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0491s00 table.
	 * 
	 *  filterAb0491s00
	 *            Ab0491s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0491s00 the filter ab 0491 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(TipoDocumento filterAb0491s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0491s00Dao.reorderSelection(filterAb0491s00,
				jqGridRequestDto, startsWith);
	}

}
